

/*
 * Segundo Exemplo do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */
import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;

/**
 * Essa classe implementa um Al Mundo! Grfico
 * Ela deve estender da classe MIDlet, criar e
 * inicializar o Canvas a ser mostrado, criar um
 * comando e prover o cdigo de tratamento para
 * o pressionamento do mesmo.
 */
public class SegundoMIDlet extends MIDlet implements CommandListener {

    /** Comando usado pra sair da aplicao */
    private static final Command exit = new Command("SAIR", Command.EXIT, 1);

    /** Tela da aplicao */
    private MeuCanvas canvas;

    /**
     * Ponto de entrada da aplicao.  o primeiro mtodo a ser chamado
     * pela KVM ao iniciar o MIDlet.
     */
    public void startApp() {

        //Cria um canvas com o ttulo "Meu Primeiro MIDlet"
        canvas = new MeuCanvas("Meu Primeiro MIDlet");

        //Seta o listener pra ser o MIDlet
        canvas.setCommandListener(this);

        // Adiciona o comando EXIT no form
        canvas.addCommand(exit);

        //sa o display para mostrar a tela criada
        Display.getDisplay(this).setCurrent(canvas);
    }

    /**
     * Mtodo invocado pela KVM no momento de uma interrupo externa.
     */
    public void pauseApp() {}

    /**
     * Usado para sair da aplicao
     *
     * @param unc Se for true, o MIDlet deve liberar todos os recursos
     *            que esto sendo usados e sair. Se for false, deve
     *            levantar uma MIDletStateChangeException indicando que
     *            ele no deve ser destrudo agora, caso esteja usando
     *            algum recurso.
     */
    public void destroyApp(boolean unc) {
        Display.getDisplay(this).setCurrent(null);
    }

    /**
     * Mtodo da interface CommandListener que  chamado ao pressionamento
     * das softkeys que possuem comandos associados.
     *
     * @param cmd Comando que foi pressionado
     * @param s   Tela que disparou o comando
     */
    public void commandAction(Command cmd, Displayable s) {
        //Caso o comando seja o de EXIT, sai da aplicao
        if (cmd == exit) {
            destroyApp(true);
            notifyDestroyed();
        }
    }

}

